<?php
require_once __DIR__ . '/../app/auth.php';
require_once __DIR__ . '/../app/models/Transaction.php';
require_auth();

$rows = Transaction::allForUser(current_user_id());

require __DIR__ . '/../app/views/head.php';
require __DIR__ . '/../app/views/navbar.php';
?>
<div class="container">
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h3 class="mb-0">Your Transactions</h3>
    <a class="btn btn-success" href="/add_transaction.php">+ Add</a>
  </div>

  <div class="card shadow-sm">
    <div class="card-body">
      <?php if(!$rows): ?>
        <p class="text-muted mb-0">No transactions yet.</p>
      <?php else: ?>
        <div class="table-responsive">
          <table class="table table-hover align-middle">
            <thead>
              <tr>
                <th>Title</th>
                <th>Category</th>
                <th>Type</th>
                <th class="text-end">Amount</th>
                <th>Date</th>
                <th class="text-end">Action</th>
              </tr>
            </thead>
            <tbody>
            <?php foreach($rows as $r): ?>
              <tr>
                <td><?= e($r['title']) ?></td>
                <td><?= e($r['category'] ?? '-') ?></td>
                <td>
                  <span class="badge <?= $r['type']==='income'?'bg-success':'bg-danger' ?>">
                    <?= e($r['type']) ?>
                  </span>
                </td>
                <td class="text-end"><?= number_format((float)$r['amount'], 2) ?></td>
                <td><?= e($r['created_at']) ?></td>
                <td class="text-end">
                  <form method="post" action="/delete_transaction.php" onsubmit="return confirm('Delete this transaction?');" class="d-inline">
                    <?php require_once __DIR__ . '/../app/middleware/csrf.php'; ?>
                    <?= csrf_field() ?>
                    <input type="hidden" name="id" value="<?= (int)$r['id'] ?>">
                    <button class="btn btn-sm btn-outline-danger">Delete</button>
                  </form>
                </td>
              </tr>
            <?php endforeach; ?>
            </tbody>
          </table>
        </div>
      <?php endif; ?>
    </div>
  </div>
</div>
<?php require __DIR__ . '/../app/views/foot.php'; ?>
