<?php
require_once __DIR__ . '/../app/security.php';
require_once __DIR__ . '/../app/helpers.php';
require_once __DIR__ . '/../app/middleware/csrf.php';
require_once __DIR__ . '/../app/models/User.php';
require_once __DIR__ . '/../app/auth.php';

start_secure_session();

$errors = [];
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    verify_csrf();

    $name = trim((string)post('name'));
    $email = trim((string)post('email'));
    $password = (string)post('password');

    if ($name === '' || strlen($name) < 2) $errors[] = "Name is required (min 2 chars).";
    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) $errors[] = "Valid email is required.";
    if (strlen($password) < 6) $errors[] = "Password must be at least 6 characters.";

    if (!$errors) {
        if (User::findByEmail($email)) {
            $errors[] = "Email already exists.";
        } else {
            $hash = password_hash($password, PASSWORD_DEFAULT);
            $uid = User::create($name, $email, $hash);
            login_user($uid);
            redirect('/dashboard.php');
        }
    }
}

require __DIR__ . '/../app/views/head.php';
require __DIR__ . '/../app/views/navbar.php';
?>
<div class="container">
  <div class="row justify-content-center">
    <div class="col-md-6">
      <div class="card shadow-sm">
        <div class="card-body">
          <h3 class="mb-3">Create account</h3>

          <?php if($errors): ?>
            <div class="alert alert-danger">
              <ul class="mb-0">
                <?php foreach($errors as $e): ?><li><?= e($e) ?></li><?php endforeach; ?>
              </ul>
            </div>
          <?php endif; ?>

          <form method="post">
            <?= csrf_field() ?>
            <div class="mb-3">
              <label class="form-label">Name</label>
              <input class="form-control" name="name" value="<?= e((string)post('name')) ?>" required>
            </div>
            <div class="mb-3">
              <label class="form-label">Email</label>
              <input type="email" class="form-control" name="email" value="<?= e((string)post('email')) ?>" required>
            </div>
            <div class="mb-3">
              <label class="form-label">Password</label>
              <input type="password" class="form-control" name="password" minlength="6" required>
            </div>
            <button class="btn btn-success w-100">Register</button>
          </form>
          <div class="mt-3 text-center">
            Already have an account? <a href="/login.php">Login</a>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
<?php require __DIR__ . '/../app/views/foot.php'; ?>
