<?php
require_once __DIR__ . '/../app/auth.php';
require_once __DIR__ . '/../app/models/User.php';
require_once __DIR__ . '/../app/models/Transaction.php';
require_auth();

$user = User::find(current_user_id());
$summary = Transaction::summaryForUser(current_user_id());

require __DIR__ . '/../app/views/head.php';
require __DIR__ . '/../app/views/navbar.php';
?>
<div class="container">
  <div class="row">
    <div class="col-12">
      <div class="p-4 bg-white rounded shadow-sm">
        <h2 class="mb-1">Welcome, <?= e($user['name'] ?? 'User') ?> 👋</h2>
        <p class="text-muted mb-4">Track your income and expenses securely.</p>

        <div class="row g-3">
          <div class="col-md-4">
            <div class="card shadow-sm">
              <div class="card-body">
                <h6 class="text-muted">Total Income</h6>
                <h3><?= number_format($summary['income_total'], 2) ?></h3>
              </div>
            </div>
          </div>
          <div class="col-md-4">
            <div class="card shadow-sm">
              <div class="card-body">
                <h6 class="text-muted">Total Expense</h6>
                <h3><?= number_format($summary['expense_total'], 2) ?></h3>
              </div>
            </div>
          </div>
          <div class="col-md-4">
            <div class="card shadow-sm">
              <div class="card-body">
                <h6 class="text-muted">Balance</h6>
                <h3><?= number_format($summary['balance'], 2) ?></h3>
              </div>
            </div>
          </div>
        </div>

        <div class="mt-4 d-flex gap-2">
          <a class="btn btn-success" href="/add_transaction.php">Add Transaction</a>
          <a class="btn btn-outline-primary" href="/transactions.php">View Transactions</a>
        </div>
      </div>
    </div>
  </div>
</div>
<?php require __DIR__ . '/../app/views/foot.php'; ?>
