<?php
require_once __DIR__ . '/../app/auth.php';
require_once __DIR__ . '/../app/helpers.php';
require_once __DIR__ . '/../app/middleware/csrf.php';
require_once __DIR__ . '/../app/models/Transaction.php';

require_auth();
$errors = [];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    verify_csrf();

    $title = trim((string)post('title'));
    $amount = post('amount');
    $type = (string)post('type');
    $category = trim((string)post('category')) ?: null;

    if ($title === '' || strlen($title) < 2) $errors[] = "Title is required (min 2 chars).";
    if (!validate_amount($amount)) $errors[] = "Amount must be a valid non-negative number.";
    if (!is_valid_type($type)) $errors[] = "Type must be income or expense.";

    if (!$errors) {
        Transaction::create(current_user_id(), $title, (float)$amount, $type, $category);
        redirect('/transactions.php');
    }
}

require __DIR__ . '/../app/views/head.php';
require __DIR__ . '/../app/views/navbar.php';
?>
<div class="container">
  <div class="row justify-content-center">
    <div class="col-md-7">
      <div class="card shadow-sm">
        <div class="card-body">
          <h3 class="mb-3">Add Transaction</h3>

          <?php if($errors): ?>
            <div class="alert alert-danger">
              <ul class="mb-0">
                <?php foreach($errors as $e): ?><li><?= e($e) ?></li><?php endforeach; ?>
              </ul>
            </div>
          <?php endif; ?>

          <form method="post">
            <?= csrf_field() ?>
            <div class="mb-3">
              <label class="form-label">Title</label>
              <input class="form-control" name="title" value="<?= e((string)post('title')) ?>" required>
            </div>
            <div class="mb-3">
              <label class="form-label">Amount</label>
              <input type="number" step="0.01" min="0" class="form-control" name="amount" value="<?= e((string)post('amount')) ?>" required>
            </div>
            <div class="mb-3">
              <label class="form-label">Type</label>
              <select class="form-select" name="type" required>
                <option value="income" <?= (post('type')==='income'?'selected':'') ?>>Income</option>
                <option value="expense" <?= (post('type')==='expense'?'selected':'') ?>>Expense</option>
              </select>
            </div>
            <div class="mb-3">
              <label class="form-label">Category (optional)</label>
              <input class="form-control" name="category" value="<?= e((string)post('category')) ?>">
            </div>
            <button class="btn btn-success w-100">Save</button>
          </form>

        </div>
      </div>
    </div>
  </div>
</div>
<?php require __DIR__ . '/../app/views/foot.php'; ?>
