<?php
require_once __DIR__ . '/../db.php';

class User {
    public static function findByEmail(string $email): ?array {
        $conn = db();
        $stmt = $conn->prepare("SELECT id, name, email, password FROM users WHERE email=? LIMIT 1");
        $stmt->bind_param("s", $email);
        $stmt->execute();
        $res = $stmt->get_result();
        return $res->num_rows ? $res->fetch_assoc() : null;
    }

    public static function create(string $name, string $email, string $hashed): int {
        $conn = db();
        $stmt = $conn->prepare("INSERT INTO users(name,email,password) VALUES(?,?,?)");
        $stmt->bind_param("sss", $name, $email, $hashed);
        $stmt->execute();
        return $stmt->insert_id;
    }

    public static function find(int $id): ?array {
        $conn = db();
        $stmt = $conn->prepare("SELECT id, name, email FROM users WHERE id=? LIMIT 1");
        $stmt->bind_param("i", $id);
        $stmt->execute();
        $res = $stmt->get_result();
        return $res->num_rows ? $res->fetch_assoc() : null;
    }
}
