<?php
require_once __DIR__ . '/dotenv.php';
load_env(__DIR__ . '/../.env');

function env(string $key, $default=null) {
    $val = getenv($key);
    return $val !== false ? $val : $default;
}

define('APP_NAME', env('APP_NAME', 'MoneyMate'));
define('APP_ENV', env('APP_ENV', 'local'));
define('APP_DEBUG', filter_var(env('APP_DEBUG', 'false'), FILTER_VALIDATE_BOOLEAN));
define('APP_URL', env('APP_URL', 'http://localhost:8000'));

define('DB_HOST', env('DB_HOST', '127.0.0.1'));
define('DB_PORT', env('DB_PORT', '3306'));
define('DB_NAME', env('DB_NAME', 'moneymate'));
define('DB_USER', env('DB_USER', 'root'));
define('DB_PASS', env('DB_PASS', ''));

define('SESSION_SECURE', filter_var(env('SESSION_SECURE', 'false'), FILTER_VALIDATE_BOOLEAN));
define('SESSION_SAMESITE', env('SESSION_SAMESITE', 'Lax'));
