<?php
require_once __DIR__ . '/security.php';

function require_auth(): void {
    start_secure_session();
    if (empty($_SESSION['user_id'])) {
        header("Location: /login.php");
        exit;
    }
}

function current_user_id(): ?int {
    start_secure_session();
    return isset($_SESSION['user_id']) ? (int)$_SESSION['user_id'] : null;
}

function login_user(int $user_id): void {
    start_secure_session();
    session_regenerate_id(true);
    $_SESSION['user_id'] = $user_id;
}

function logout_user(): void {
    start_secure_session();
    $_SESSION = [];
    if (ini_get("session.use_cookies")) {
        $params = session_get_cookie_params();
        setcookie(session_name(), '', time() - 42000,
            $params["path"], $params["domain"],
            $params["secure"], $params["httponly"]
        );
    }
    session_destroy();
}
