# MoneyMate (Secure PHP + MySQL)

A simple, secure finance tracker app:
- Register / Login / Logout
- Add income/expense transactions
- List & delete transactions (ownership enforced)
- Dashboard summary

## ✅ Security features
- Prepared statements everywhere (SQLi protection)
- CSRF protection on all POST actions
- Output escaping to prevent XSS
- Secure session settings (HttpOnly, SameSite, optional Secure)
- Password hashing via `password_hash()` / `password_verify()`
- Centralized input validation
- Ownership checks (user_id) on reads/deletes
- Basic rate limiting for login attempts (session-based)

---

## Requirements
- PHP 8.0+ (PHP 7.4 should work)
- MySQL/MariaDB
- Web server (Apache/Nginx) OR PHP built-in server

---

## Setup

### 1) Create database
```sql
CREATE DATABASE moneymate CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
```

### 2) Import schema
```bash
mysql -u root -p moneymate < database/schema.sql
```

### 3) Configure env
Copy `.env.example` to `.env` and fill values:
```bash
cp .env.example .env
```

### 4) Run locally
Using PHP built-in server:
```bash
php -S localhost:8000 -t public
```

Open: http://localhost:8000

---

## Production notes
- Set `APP_ENV=production`
- Set `SESSION_SECURE=true` (requires HTTPS)
- Use a restricted DB user (least privilege)
- Turn off display_errors; log errors instead
- Schedule backups:
```bash
mysqldump -u user -p moneymate | gzip > backup_$(date +%F).sql.gz
```

---

## Tests
Example PHPUnit scaffolding:
```bash
composer install
vendor/bin/phpunit
```
